
DEFAULTS {

    heap_reserve = 16K
    stack_reserve = 4K

}

MEMORY {

    // Start the application at 0x2008000 so as to not overwrite angel
    dram_memory  : ORIGIN = 0x3f000000,	 	LENGTH = 1300K-stack_reserve
    stack_ram : org = (0x3f000000+1300K-stack_reserve)    len = stack_reserve

    
    flash_rsvd1  : ORIGIN = 0x00000000, LENGTH = 0
    flash_memory : ORIGIN = .,          LENGTH = 16M
    flash_rsvd2  : ORIGIN = .,          LENGTH = 0

}

//
// Program layout for running out of RAM.
//
//

SECTIONS
{

//
// The text segment
//

    .picbase                                            : > dram_memory
    .text                                               : > .
    .syscall                                            : > .
    .intercall                                          : > .
    .interfunc                                          : > .
    .fixaddr                                            : > .
    .fixtype                                            : > .
    .rodata                                             : > .
    .secinfo                                            : > .
	.intvec    ALIGN(0x800)   : {} > .   /* ISR Vector Table - must be 2K aligned */

//
// The data segment
//

    .pidbase                                  ALIGN(16) : > .
    .sdabase                                            : > .
    .sbss                                               : > .
    .sdata                                              : > .
    .data                                               : > .
    .bss                                                : > .
    .ghcovfz					  CLEAR : > .
    .ghcovcz					  CLEAR : > .
    .ghcovdz					  CLEAR : > .
    .heap                   ALIGN(16) PAD( heap_reserve +
	    // Add space for call-graph profiling if used:
	    (isdefined(__ghs_indgcount)?(2000+(sizeof(.text)/2)):0) +
	    // Add estimated space for call-count profiling if used:
	    (isdefined(__ghs_indmcount)?10000:0) )
	    						: > .
    .stack                 ALIGN(16) PAD(stack_reserve) : > stack_ram
//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    //__ghs_romstart  = MEMADDR(flash_rsvd1);
    //__ghs_romend    = MEMENDADDR(flash_rsvd2);
    __ghs_ramstart  = MEMADDR(dram_memory);
    __ghs_ramend    = MEMENDADDR(dram_memory);

	p_tabsSAM	= (0x3EF00000);
	p_stage_tcSAM = (p_tabsSAM + 0x13900);	
	p_baseSAM	= (p_stage_tcSAM + 0x13900);	

	__CONTRAM_start    = (p_stage_tcSAM);
	__CONTRAM_start_GPU    =(__CONTRAM_start + 128K);
	__CONTRAM_end        = (__CONTRAM_start_GPU + 880K);    
	
	/*-------- LABELS USED IN CODE ---------------------------*/

	/* Stack Address Parameters */
	__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram);

	/* Interrupt Handler Parameters */
	//__IVPR = ADDR(.xptn_vectors);
        
}
